RegisterCommand(Settings.Announce.Command.CommandName, function(source,args,rawCommand)
    local source = source
    local user_id = getUserID(source)

    if not user_id then
        return
    end

    if Settings.Announce.Command.Permission then
        if not hasPermission(user_id, Settings.Announce.Command.Permission) then
            return
        end
    end

    local title = prompt(source, Settings.Announce.Command.Params[1], "")
    if not title or title == '' then
        return
    end

    local description = prompt(source, Settings.Announce.Command.Params[2], "")
    if not description or description == '' then
        return
    end

    local author = getAuthor(user_id)

    local time = prompt(source, Settings.Announce.Command.Params[3], "")
    if not time or time == '' or tonumber(time) == nil then
        time = Settings.Announce.DefaultTime
    else
        time = tonumber(time) * 1000
    end

    TriggerClientEvent(Settings.Announce.EventName, -1, title, description, author, time)
end)

RegisterCommand(Settings.Announce.Delete.CommandName, function(source,args,rawCommand)
    local source = source
    local user_id = getUserID(source)

    if not user_id then
        return
    end

    if Settings.Announce.Delete.Permission then
        if not hasPermission(user_id, Settings.Announce.Delete.Permission) then
            return
        end
    end

    TriggerClientEvent(Settings.Announce.Delete.EventName, -1)
end)

local posController = {}
hvClient = Tunnel.getInterface(GetCurrentResourceName())
RegisterCommand(Settings.Position.CommandName, function(source,args,rawCommand)
    if posController[source] and posController[source] >= os.time() then
        return
    end

    local source = source
    local user_id = getUserID(source)

    if not user_id then
        return
    end

    if Settings.Position.Permission then
        if not hasPermission(user_id, Settings.Position.Permission) then
            return
        end
    end

    local cds = hvClient.getPosition(source)
    local message = "Localização de " .. getAuthor(user_id) .. " marcada no mapa"
    local users = getUsersByPermission(Settings.Position.Permission)

    posController[source] = os.time() + Settings.Position.Timeout + 1

    for l,w in pairs(users) do
        local target = getUserSource(w)
        if target then
            TriggerClientEvent(
                Settings.Position.EventName, 
                target, 
                math.floor(cds.x)+0.00,
                math.floor(cds.y)+0.00,
                math.floor(cds.z)+0.00,
                message,
                user_id
            )
        end
    end
end)

RegisterCommand('highshop' ,function(source,args,rawCommand)
    local source = source
    TriggerClientEvent("Notify", source, "sucesso", "HighShop", "High Shop Melhor Loja", 8000)
    TriggerClientEvent("Notify", source, "negado", "HighShop", "High Shop Melhor Loja", 10000)
    TriggerClientEvent("Notify", source, "aviso", "HighShop", "High Shop Melhor Loja", 12000)
    TriggerClientEvent("Notify", source, "policia", "HighShop", "High Shop Melhor Loja", 14000)
    TriggerClientEvent("itemNotify", source, "recebido", "redbull", "Redbull", 2)
    TriggerClientEvent("itemNotify", source, "removido", "redbull", "Redbull", 1)
end)